// Scans a terrain and dumps raw heights to console.log
// Written by Michael "KineticPoet" Johnston at Irrational Games Australia.
// Thanks to Mark Frohnmayer for the idea.

// DISCLAIMER
// Use this script and the accompanying program at your own risk.  It's a bit
// of a convoluted solution, but it works.


// REQUIREMENTS
//
// 1.  ConvTED.exe to convert the text dump to a raw binary file.  This was
//     written by me and should be bundled with this script.
// 2.  A program that can interpret raw binary files as bitmaps.
// 	a) Adobe Photoshop.  Open your .raw file.  Set the import options to
//	   16-bits, 1 channel, IBM-PC.
//	b) Daylon Leveller.  This is the program I use.  Import a raw binary
//         file.  Set options to 512x512, unsigned 16-bit integers, Intel,
//         0 byte header.  Leveller is available at:
//         http://www.daylongraphics.com/products/leveller/


// HOW IT WORKS
//
// A script scans a Tribes1 map by casting successive downward rays to measure
// height values.  These height values are dumped as text numbers into the
// console log.  A separate .exe converts the text dump to a binary dump.  The
// binary dump can be interpreted by a 3rd party program as a bitmap.  The 
// bitmap can be interpreted by a game engine (such as Tribes Vengeance, 
// Tribes 2, Torque or Unreal) as a heightfield.


// INSTRUCTIONS
//
// 1.  Copy this script to your Tribes 1 base directory.
// 2.  Delete console.log from your base directory if it exists.
// 3.  Open Tribes 1.  Load your desired level.  Delete any objects that you
//     don't want interfering with the heightfield data, like the bridges
//     in Dangerous Crossing.  I tend to leave objects like bases in the level,
//     which then causes them to appear as irregular terrain in the exported
//     data, thus allowing you to orient yourself on the map.
// 4.  Spawn as a player and open the console by pressing ~.
// 5.  Type exec("exportTerrain.cs"); and hit enter.
// 6.  Type exportTerrain(); and hit enter.
// 7.  Exit Tribes.  Open console.log in notepad (it's in your Tribes
//     directory).  Delete everything before and including "START TERRAIN
//     HEIGHTS" at the top of the file.  At the bottom of the file, delete
//     everything after and including "END TERRAIN HEIGHTS."  You should be
//     left with a file that only has numbers in it.  Save it.
// 8.  Open a DOS prompt and navigate to your Tribes directory (assuming this
//     is where your ConvTED.exe is stored).
// 9.  Type "convTED console.log myMap.raw" and hit enter.
// 10. If you saved your log as something else, enter its name in place of
//     console.log.  Replace myMap.raw with whatever name you want.
// 11. Open the .raw file in Adobe Photoshop or Daylon Leveller using the
//     settings described at the top of this file.  The imported image size
//     should correspond to the minExtent and maxExtent settings in the script.
//     These values are configured for a 256x256 heightfield by default.
// 12. Save the file in your format of choice, likely a greyscale .bmp file.    
// 13. Import the image file into your engine of choice.


function exportTerrain(%this)
{
// Set minExtent and maxExtent according to the desired size of your
// output heightfield.

// 512x512
//%minExtent = -2048;
//%maxExtent = 2048;

// 256x256
%minExtent = -1024;
%maxExtent = 1024;

// 128x128
//%minExtent = -512;
//%maxExtent = 512;

// 64x64
//%minExtent = -256;
//%maxExtent = 256;

	%zmeasure = 400;
	%loscheck = "-1.570796325 0 0";
	%smallest = 9999;

	$Console::logMode = "1";
	echo("START TERRAIN HEIGHTS");
      	%player = Client::getOwnedObject(getClientByIndex(0));
	for (%y = %minExtent; %y<%maxExtent; %y += 8)
	{
		// x goes backwards
		for (%x = %maxExtent; %x>%minExtent; %x -= 8)
		{
			%pos = %x @ " " @ %y @ " " @ %zmeasure;
			Gamebase::setPosition(%player, %pos);
			Gamebase::getLOSInfo(%player, %zmeasure, %loscheck);
			%height = getWord($los::position, 2);
			%temp = floor(%height * 100);
			//if (%temp < %smallest)
			//	%smallest = %temp;
			echo(%temp);
		}
	}
	echo("END TERRAIN HEIGHTS");
	$Console::logMode = "0";
	echo("Terrain heights logged to console.log");
	//echo("min = " @ %smallest);
}
